/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.data;

import de.unhappycodings.quarry.common.blocks.ModBlocks;
import de.unhappycodings.quarry.common.blocks.QuarryBlock;
import de.unhappycodings.quarry.common.util.ItemUtil;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModelAndBlockStatesProvider
extends BlockStateProvider {
    DataGenerator gen;

    public ModelAndBlockStatesProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "quarry", exFileHelper);
        this.gen = gen;
    }

    private static int getSensorRotation(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    protected void registerStatesAndModels() {
        this.quarryBlock((QuarryBlock)((Object)ModBlocks.QUARRY.get()));
    }

    public void quarryBlock(QuarryBlock block) {
        ModelBuilder quarryOff = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ItemUtil.getRegString((Block)block) + "_off", new ResourceLocation("quarry", "generation/quarry_block"))).texture("1", new ResourceLocation("quarry", "block/quarry_block_off"))).texture("2", new ResourceLocation("quarry", "block/quarry_block_side"))).texture("3", new ResourceLocation("quarry", "block/quarry_block_top"))).texture("particle", new ResourceLocation("quarry", "block/quarry_block_side"));
        ModelBuilder quarryIdle = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ItemUtil.getRegString((Block)block) + "_idle", new ResourceLocation("quarry", "generation/quarry_block"))).texture("1", new ResourceLocation("quarry", "block/quarry_block_idle"))).texture("2", new ResourceLocation("quarry", "block/quarry_block_side"))).texture("3", new ResourceLocation("quarry", "block/quarry_block_top"))).texture("particle", new ResourceLocation("quarry", "block/quarry_block_side"));
        ModelBuilder quarryOn = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ItemUtil.getRegString((Block)block) + "_on", new ResourceLocation("quarry", "generation/quarry_block"))).texture("1", new ResourceLocation("quarry", "block/quarry_block_on"))).texture("2", new ResourceLocation("quarry", "block/quarry_block_side"))).texture("3", new ResourceLocation("quarry", "block/quarry_block_top"))).texture("particle", new ResourceLocation("quarry", "block/quarry_block_side"));
        ModelBuilder quarryWorking = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ItemUtil.getRegString((Block)block) + "_work", new ResourceLocation("quarry", "generation/quarry_block"))).texture("1", new ResourceLocation("quarry", "block/quarry_block_work"))).texture("2", new ResourceLocation("quarry", "block/quarry_block_side"))).texture("3", new ResourceLocation("quarry", "block/quarry_block_top"))).texture("particle", new ResourceLocation("quarry", "block/quarry_block_side"));
        this.quarryBlock(block, (ModelFile)quarryOff, (ModelFile)quarryIdle, (ModelFile)quarryOn, (ModelFile)quarryWorking);
    }

    public void quarryBlock(QuarryBlock block, ModelFile off, ModelFile idle, ModelFile on, ModelFile work) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)QuarryBlock.FACING);
            boolean powered = (Boolean)state.m_61143_((Property)QuarryBlock.POWERED);
            boolean working = (Boolean)state.m_61143_((Property)QuarryBlock.WORKING);
            boolean active = (Boolean)state.m_61143_((Property)QuarryBlock.ACTIVE);
            if (powered && !active) {
                return ConfiguredModel.builder().modelFile(idle).rotationY(ModelAndBlockStatesProvider.getSensorRotation(facing)).build();
            }
            if (active && !working) {
                return ConfiguredModel.builder().modelFile(on).rotationY(ModelAndBlockStatesProvider.getSensorRotation(facing)).build();
            }
            if (working) {
                return ConfiguredModel.builder().modelFile(work).rotationY(ModelAndBlockStatesProvider.getSensorRotation(facing)).build();
            }
            return ConfiguredModel.builder().modelFile(off).rotationY(ModelAndBlockStatesProvider.getSensorRotation(facing)).build();
        });
    }
}

